#!/usr/bin/python
__doc__ = '''A minimal structure for a real-time game featuring a saucer.
Version 0 only has a single saucer, player-controlled, and does not use user-defined objects'''
import pygame
from pygame.locals import *

X, Y = 500, 500 # Controls the screen size
T = 40 # Controls the timing, one movement every T milliseconds
S = 15 # Controls the step size in pixels

def run(screen, player, x, y):
	'''Game loop'''
	while True : # infinite loop
		for e in pygame.event.get(): #check for events (keys pressed)
				cmd=pygame.key.get_pressed() # get all pressed keys!
				if cmd[K_q] : return # if 'q' pressed, leave game
				# check all possible movement keys
				if cmd[K_a] or cmd[K_LEFT]  : x = x-S
				if cmd[K_d] or cmd[K_RIGHT] : x = x+S
				if cmd[K_s] or cmd[K_DOWN]  : y = y+S
				if cmd[K_w] or cmd[K_UP]    : y = y-S
		screen.fill((0,0,0)) # Draw black screen
		pygame.draw.circle(screen, player['color'], (x,y), player['radius']) # Draw player
		pygame.display.update() # Update the display
		pygame.time.delay(T) # wait T milliseconds

if __name__ == "__main__" :
	pygame.init()
	pygame.display.set_caption('Saucers')
	pygame.key.set_repeat(T,T)
	screen=pygame.display.set_mode((X,Y),0)
	player={ 'radius' : 30, 'color' : (0,120,255) } 
	run(screen, player, X/2, Y/2)
