#!/usr/bin/python
__doc__ = '''A minimal structure for a real-time game featuring a saucer. 
Version 2 adds random objects flying in the game world. No collision detection is available.'''

import pygame
import pygame.event
from pygame.locals import *

from random import randint

X, Y = 500, 500 # Controls the screen size
FPS = 30 # Controls the timing, FPS frames per second
S = 15 # Controls the step size in pixels
F = 10 # Controls the frequency of enemies. One enemy appears every 1/F T time units

def rand_color():
	return randint(0,255),randint(0,255), randint(0,255)

class Saucer(object):
	'''Description of a saucer, characterized by position (x,y), radius r, and color (r,g,b)'''
	def __init__(self, size=None, color=None, pos=None):
		if not size : size=randint(10,40)
		if not color : color=rand_color()
		if not pos : pos=(randint(0,X),0)
		self.radius=size
		self.color=color
		self.pos=pos

class GameBoard(object):
	'''Description of the game board and all the related functionalities'''
	def __init__(self, X,Y):
		self.X=X
		self.Y=Y
		pygame.init()
		# Display and other intializations
		self.srect=Rect(0,0,self.X, self.Y)
		self.screen=pygame.display.set_mode(self.srect.size,0)
		self.bg = pygame.Surface(self.srect.size)
		self.clock=pygame.time.Clock()
		pygame.display.set_caption('Saucers')
		pygame.key.set_repeat(FPS,FPS)
		# Game actors
		self.player=Saucer(30, (0,120,255), (self.X/2, self.Y/2))
		self.objects=[]

	def blitAll(self):
		# Draw black screen
		self.screen.fill((0,0,0))
		for o in self.objects:
			pygame.draw.circle(self.screen, o.color, o.pos, o.radius)
		pygame.draw.circle(self.screen, self.player.color, self.player.pos, self.player.radius)
		pygame.display.update()

	def random_gen(self, freq=F):
		if randint(1,freq)==1:
			self.objects.append(Saucer())

	def move_all(self):
		for o in self.objects :
			x, y = o.pos
			o.pos = x, y+S
		self.objects = [ o for o in self.objects if o.pos[1]<self.Y and o.pos[0]<self.X ]

	def run(self):
		while True :
			self.random_gen()
			for e in pygame.event.get():
				print e
				if e.type==KEYDOWN :
					cmd=pygame.key.get_pressed()
					x, y = self.player.pos
					if cmd[K_q] : return
					if cmd[K_a] or cmd[K_LEFT] : self.player.pos = x-S, y
					if cmd[K_d] or cmd[K_RIGHT] : self.player.pos = x+S, y
					if cmd[K_s] or cmd[K_DOWN] : self.player.pos = x, y+S
					if cmd[K_w] or cmd[K_UP] : self.player.pos = x, y-S
			self.blitAll()
			self.clock.tick(FPS)
			self.move_all()


if __name__ == "__main__" :
	game=GameBoard(X,Y)
	game.run()
