'''
Heapsort: come Selection sort, ma usa uno heap (una struttura ad albero in cui gli elementi piu' grandi vengono man mano spostati verso l'alto, risalendo al massimo per log n posizioni) per ottimizzare la ricerca del minimo o massimo valore.
'''
def Parent(i): return i/2
def Left(i): return 2*i
def Right(i): return 2*i+1

def Heapify(A, i, n): 
    l = Left(i)
    r = Right(i)
    if l <= n and A[l] > A[i]: largest = l
    else: largest = i
    if r <= n and A[r] > A[largest]:
        largest = r
    if largest != i:
        A[i], A[largest] = A[largest], A[i]
        Heapify(A, largest, n)

def HeapLength(A): return len(A)-1

def BuildHeap(A): 
    n = HeapLength(A)
    for i in range(n/2,0,-1):
        Heapify(A,i,n)

def HeapSort(A): 
    BuildHeap(A)
    HeapSize=HeapLength(A)
    for i in range(HeapSize,1,-1):
        A[1],A[i]=A[i],A[1] 
        HeapSize=HeapSize-1 
        Heapify(A,1,HeapSize)
    return A

if __name__=='__main__' :
	print HeapSort([1,7,43,9,2,10,23,4,75])
