def merge(left,right):
    result=[]
    while len(left) > 0 and len(right) > 0 :
        if left[0] <= right[0] :
            result.append(left[0]) 
            left = left[1:]
        else :
            result.append(right[0])
            right = right[1:]
    if len(left) > 0 :
        result+=left
    if len(right) > 0 :
        result+=right
    return result

def sort(m):
'''An implementation of mergesort, in a plain, imperative style.
'''
		left=[]
		right=[]
		result=[]
		if len(m) <= 1 :
			return m
		else :
			middle = len(m) / 2
			left = m[:middle]
			right = m[middle:]
			left = sort(left)
			right = sort(right)
			result = merge(left, right)
			return result


def merge2(left,right):
'''Here we have a more concise version of the merge function by collecting the actions in the main loop in a service function (declared with local scope since it's only used here) and by taking advantage of the fact that [] is neutral with respect to addition between lists.
'''
		result=[]
		def popout(l,r) :
			if l[0]<=r[0] : return l.pop(0)
			else : return r.pop(0)
		while len(left) > 0 and len(right) > 0 :
			result.append(popout(left,right))
		return result+left+right

def sort2(m):
'''In this version of the sort function, we use a functional style, removing temporary variables and using computed values directly.
'''
	if len(m)<=1 : return m
	return merge2(sort2(m[:len(m)/2]),sort2(m[len(m)/2:]))


def merge3(left,right):
'''In this version of the merge function, we change the approach from iterative to recursive.
'''
	if not (len(left) and len(right)) : return left+right
	elif left[0]<=right[0] : return [left[0]]+merge3(left[1:],right)
	else : return [right[0]]+merge3(left,right[1:])

def sort3(m):
	if len(m)<=1 : return m
	return merge3(sort3(m[:len(m)/2]),sort3(m[len(m)/2:]))


def merge4(left,right):
'''And now, let's take advantage of the conditional expression recently introduced in Python to make merge a one-line function!
'''
	return left+right if not (len(left) and len(right)) else ([left[0]]+merge4(left[1:],right) if left[0]<=right[0] else [right[0]]+merge4(left,right[1:]))

def sort4(m):
'''And now, let's take advantage of the conditional expression recently introduced in Python to make sort a one-line function!
'''
	return m if len(m)<=1 else merge4(sort4(m[:len(m)/2]),sort4(m[len(m)/2:]))

'''Finally, we make these anonymous functions just to make it more cryptic :P'''
merge5 = lambda left, right : left+right if not (len(left) and len(right)) else [left[0]]+merge5(left[1:],right) if left[0]<=right[0] else [right[0]]+merge5(left,right[1:])
sort5 = lambda m : m if len(m)<=1 else merge5(sort5(m[:len(m)/2]),sort5(m[len(m)/2:]))

if __name__ == '__main__' :
	i = [ 1,3,5,2,4,6 ]
	print i
	print sort(i)
	print sort2(i)
	print sort3(i)
	print sort4(i)
	print sort5(i)
