#!/usr/bin/python
def quicksort1(arr):
   if len(arr) <= 1: return arr
   m = arr[0]
   return quicksort1(filter(lambda i,j=m: i<j, arr)) + \
			filter(lambda i,j=m: i==j, arr) + \
			quicksort1(filter(lambda i,j=m: i>j, arr))

def quicksort2(arr):
   if len(arr) <= 1: return arr
   return quicksort2([ i for i in arr if i<arr[0]]) + \
		arr[0:1] + \
		quicksort2([ i for i in arr if i>arr[0]])

if __name__=='__main__' :
	print quicksort1([1,7,43,9,2,0,23,4,75])
	print quicksort2([1,7,43,9,2,0,23,4,75])

'''
Computational cost:
T(n) = 
		O(1) 					if n==1
		T(n-1-a)+T(a)+O(n) 		if n>1

Average case:
T(n) =
		O(1)					if n==1
		2*T(n/2)+O(n)				if n>1

T(n) = O(n log n)		

Worst case:
T(n) = 
		O(1) 					if n==1
		T(n-1)+O(1)+O(n)			if n>1

T(n) = O(n^2)
'''
