/*
 * Andrea Di Biagio
 * Politecnico di Milano, 2007
 * 
 * axe_constants.h
 * Formal Languages & Compilers Machine, 2007/2008
 * 
 */

#ifndef _AXE_CONSTANTS_H
#define _AXE_CONSTANTS_H

/* registers */

/* registers */
/* REG_0 -> $zero : register always in zero*/
/* REG_AT -> $at : reserved for assembler*/
/* REG_V0 -> $v0 : expression evaluation and results of a function*/
/* REG_V1 -> $v1 : expression evaluation and results of a function*/
/* REG_A0 -> $a0 : argument 1*/
/* REG_A1 -> $a1 : argument 2*/
/* REG_A2 -> $a2 : argument 3*/
/* REG_A3 -> $a3 : argument 4*/
/* REG_K0 -> $k0 : reserved for OS kernel*/
/* REG_K1 -> $k1 : reserved for OS kernel*/
/* REG_GP -> $gp : pointer to global area*/
/* REG_SP -> $sp : stack pointer*/
/* REG_FP -> $fp : frame pointer*/
/* REG_RA -> $ra : return address*/
/* General porpouse registers Reg 8 to 25*/

#define REG_INVALID -1
#define REG_0 200
#define REG_AT 210
#define REG_V0 220
#define REG_V1 230
#define REG_A0 240
#define REG_A1 250
#define REG_A2 260
#define REG_A3 270
#define REG_K0 280
#define REG_K1 290
#define REG_GP 300
#define REG_SP 310
#define REG_FP 320
#define REG_RA 330
#define NUM_REGISTERS 18

/* opcodes pseudo-M68000 */
/*PSEUDO OPCODES*/
#define INVALID_OPCODE -1
#define NOP	0

//ternary instructions

#define ADD	1
#define ADDU	2
#define AND	3
#define DIV	4
#define DIVU	5
#define MUL	6
#define MULO	7
#define MULOU	8
#define NOR	9
#define OR	10
#define REM	11
#define REMU	12
#define SLLV	13
#define SRAV	14
#define SRLV	15
#define ROL	16
#define ROR	17
#define SUB	18
#define SUBU	19
#define XOR	20
#define SLT	21
#define SLTU	22
#define SEQ	23
#define SGE	24
#define SGEU	25
#define SGT	26
#define SGTU	27
#define SLE	28
#define SLEU	29
#define SNE	30
#define MOVN	31
#define MOVZ	32

//binary immediate instructions
#define ADDI 	33
#define ADDIU	34
#define ANDI	35
#define ORI	36
#define SLL	37
#define SRA	38
#define SRL	39
#define XORI	40
#define SLTI	41
#define SLTIU	42
	
// binary instructions
#define ABS	43
#define CLO	44
#define CLZ	45
#define DV	46
#define DVU	47
#define MULT	48
#define MULTU	49
#define MADD	50
#define MADDU	51
#define MSUB	52
#define NEG	53
#define NEGU	54
#define NOTB	55
#define JALR	56
#define TEQ	57
#define TNE	58
#define TGE	59
#define TGEU	60
#define TLT	61
#define TLTU	62
#define MOVE	63
		
// unary immediate instructions
#define LUI	64
#define LI	65
#define TEQI	66
#define TNEI	67
#define TGEI	68
#define TGEIU	69
#define TLTI	70
#define TLTIU	71
		
// unary instructions
#define JR	72
#define MFHI	73
#define MFLO	74
#define MTHI	75
#define MTLO	76

// load/store instructions
#define LA	77
#define LB	78
#define LBU	79
#define LH	80
#define LHU	81
#define LW	82
#define LWC1	83
#define LWL	84
#define LWR	85
#define LD	86
#define ULH	87
#define ULHU	88
#define ULW	89

#define SB	90
#define SH	91
#define SW	92
#define SWC1	93
#define SDC1	94
#define SWL	95
#define SWR	96
#define SD	97
#define USH	98
#define USW	99
		
// binary jump instructions
#define BEQ	100
#define BNE	101
#define BGE	102
#define BGEU	103
#define BGT	104
#define BGTU	105
#define BLE	106
#define BLEU	107
#define BLT	108
#define BLTU	109
#define BNEZ	110

// unary jump instructions
#define BGEZ	111
#define BGEZAL	112
#define BGTZ	113
#define BLEZ	114
#define BLTZAL	115
#define BLTZ	116
#define BEQZ	117

// unconditionally jump
#define B	118
#define J	119
#define JAL	120

#define SYSCALL 121

/* data types */
#define INTEGER_TYPE 0
#define UNKNOWN_TYPE -1

/* label special values */
#define LABEL_UNSPECIFIED -1

/* WARNINGS */
#define WARN_DIVISION_BY_ZERO 1

/* SIM errorcodes */
#define AXE_OK 0
#define AXE_OUT_OF_MEMORY 1
#define AXE_PROGRAM_NOT_INITIALIZED 2
#define AXE_INVALID_INSTRUCTION 3
#define AXE_VARIABLE_ID_UNSPECIFIED 4
#define AXE_VARIABLE_ALREADY_DECLARED 5
#define AXE_INVALID_TYPE 6
#define AXE_FOPEN_ERROR 7
#define AXE_FCLOSE_ERROR 8
#define AXE_INVALID_INPUT_FILE 9
#define AXE_FWRITE_ERROR 10
#define AXE_INVALID_DATA_FORMAT 11
#define AXE_INVALID_OPCODE 12
#define AXE_INVALID_REGISTER_INFO 13
#define AXE_INVALID_LABEL 14
#define AXE_INVALID_ARRAY_SIZE 15
#define AXE_INVALID_VARIABLE 16
#define AXE_INVALID_ADDRESS 17
#define AXE_INVALID_EXPRESSION 18
#define AXE_UNKNOWN_VARIABLE 19
#define AXE_LABEL_ALREADY_ASSIGNED 20
#define AXE_INVALID_LABEL_MANAGER 21
#define AXE_SY_TABLE_ERROR 22
#define AXE_NULL_DECLARATION 23
#define AXE_INVALID_CFLOW_GRAPH 24
#define AXE_INVALID_REG_ALLOC 25
#define AXE_REG_ALLOC_ERROR 26
#define AXE_TRANSFORM_ERROR 27
#define AXE_SYNTAX_ERROR 28
#define AXE_UNKNOWN_ERROR 29
#define AXE_INVALID_AM 30

/* DIRECTIVE TYPES */
#define DIR_WORD 0
#define DIR_SPACE 1
#define DIR_INVALID -1

/* ADDRESS TYPES */
#define ADDRESS_TYPE 0
#define LABEL_TYPE 1

/* CODEGEN FLAGS */
#define CG_DIRECT_ALL 0
#define CG_INDIRECT_ALL 3
#define CG_INDIRECT_DEST 1
#define CG_INDIRECT_SOURCE 2

/* ADDRESSING MODES*/
#define AM_INVALID			-1
#define AM_DIRECT			0
#define AM_INDIRECT			1
#define AM_IMMEDIATE			2
#define AM_INDIRECT_IMMEDIATE		3
#define AM_LABEL			4
#define AM_LABEL_IMMEDIATE		5
#define AM_INDIRECT_LABEL_ADDRESS	6
#define AM_INDIRECT_LABEL_IMMEDIATE	7

/* EXPRESSION TYPES */
#define IMMEDIATE 0
#define REGISTER 1
#define INVALID_EXPRESSION -1

/* C operators */
#define _AND	1
#define _OR	2
#define _XOR	3
#define _ADD	4
#define _SUB	5
#define _MUL	6
#define _DIV	7
#define _SHL	8
#define _SHR	9
#define _ANDAND	10
#define _OROR	11

/* binary comparison constants */
#define _LT_ 0
#define _GT_ 1
#define _EQ_ 2
#define _NOTEQ_ 3
#define _LTEQ_ 4
#define _GTEQ_ 5


/* Instruction Groups */
#define TERN		1
#define BIN_IMM		2
#define BIN		3
#define UNA_IMM		4
#define UNA		5
#define LOAD_STORE	6
#define BIN_JUMP	7
#define UNA_JUMP	8
#define UNCOND_JUMP	9
#define SPECIAL		10
#define INVALID_GROUP	11

#endif
