/*
 * Andrea Di Biagio
 * Politecnico di Milano, 2007
 * 
 * axe_gencode.h
 * Formal Languages & Compilers Machine, 2007/2008
 * 
 */

#ifndef _AXE_GENCODE_H
#define _AXE_GENCODE_H

#include "axe_engine.h"
#include "axe_struct.h"

 /*-------------------------------------------------------
  *                 TERNARY INSTRUCTIONS
  *------------------------------------------------------*/

/* ADD	Addition with overflow
 * */
extern t_axe_instruction * gen_add_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* ADDU	Addition without overflow
 * */
extern t_axe_instruction * gen_addu_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* AND	and bitwise
 * */
extern t_axe_instruction * gen_and_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* DIV	Divide with overflow (pseudoinstruction)
 * */
extern t_axe_instruction * gen_div_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* DIVU	Divide without overflow immediate (pseudoinstruction)
 * */
extern t_axe_instruction * gen_divu_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* MUL	Multiply without overflow
 ** */
extern t_axe_instruction * gen_mul_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* MULO	Multiply with overflow (pseudoinstruction)
 * */
extern t_axe_instruction * gen_mulo_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* MULOU	Unsigned multiply with overflow (pseudoinstruction)
 * */
extern t_axe_instruction * gen_mulou_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* NOR	nor bitwise
 * */
extern t_axe_instruction * gen_nor_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* OR	or bitwise
 * */
extern t_axe_instruction * gen_or_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);
      

/* REM	Remainder (pseudoinstruction)
 ** */
extern t_axe_instruction * gen_rem_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* REMU	Unsigned remainder (pseudoinstruction)
 * */
extern t_axe_instruction * gen_remu_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* SLLV	Shift left logical variable
 * */
extern t_axe_instruction * gen_sllv_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* SRAV	Shift right arithmetic variable
 ** */
extern t_axe_instruction * gen_srav_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* SRLV	Shift right logical variable
 * */
extern t_axe_instruction * gen_srlv_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* ROL	Rotate Left (pseudoinstruction)
 * */
extern t_axe_instruction * gen_rol_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* ROR	Rotate Right (pseudoinstruction)
 ** */
extern t_axe_instruction * gen_ror_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* SUB	Subtract with overflow
 * */
extern t_axe_instruction * gen_sub_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* SUBU	Subtract without overflow
 * */
extern t_axe_instruction * gen_subu_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* XOR	Exclusive or
 * */
extern t_axe_instruction * gen_xor_instruction (t_program_infos *program
      , int r_dest, int r_source1, int r_source2);

/* SLT	Set less than
 * */
extern t_axe_instruction * gen_slt_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/* SLTU	Set less than unsigned
 * */
extern t_axe_instruction * gen_sltu_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/* SEQ	Set equal (pseudoinstruction)
 * */
extern t_axe_instruction * gen_seq_instruction
	(t_program_infos *program, int r_dest, int r_source1, int r_source2);

/* SGE	Set greater than equal (pseudoinstruction)
 * */
extern t_axe_instruction * gen_sge_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/* SGEU	Set greater than equal unsigned (pseudoinstruction)
 * */
extern t_axe_instruction * gen_sgeu_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/* SGT	Set greater than (pseudoinstruction)
 * */
extern t_axe_instruction * gen_sgt_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/* SGTU	Set greater than unsigned (pseudoinstruction)
 * */
extern t_axe_instruction * gen_sgtu_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/* SLE	Set less than equal (pseudoinstruction)
 * */
extern t_axe_instruction * gen_sle_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/* SLEU	Set less than equal unsigned (pseudoinstruction)
 ** */
extern t_axe_instruction * gen_sleu_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/*  SNE	Set not equal (pseudoinstruction)
 * */
extern t_axe_instruction * gen_sne_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);
		

/*  MOVN	Move conditional not zero
 * 
 **/
extern t_axe_instruction * gen_movn_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

/*  MOVZ	Move conditional zero
 * 
 **/
extern t_axe_instruction * gen_movz_instruction(t_program_infos *program
	, int r_dest, int r_source1, int r_source2);

 /*-------------------------------------------------------
  *            BINARY IMMEDIATE INSTRUCTIONS
  *------------------------------------------------------*/
 

/* ADDI 	Addition immediate with overflow
 * */
extern t_axe_instruction * gen_addi_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);

/* ADDIU	Addition immediate without overflow
 * */
extern t_axe_instruction * gen_addiu_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);

/* ANDI	and bitwise immediate
 * */
extern t_axe_instruction * gen_andi_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);
	
/* ORI	or bitwise immediate
 **/
extern t_axe_instruction * gen_ori_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);

/* SLL	Shift left logical
 ** */
extern t_axe_instruction * gen_sll_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);

/* SRA	Shift rigth arithmetic
 * */
extern t_axe_instruction * gen_sra_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);

/* SRL	Shift rigth logical
 * */
extern t_axe_instruction * gen_srl_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);
				

/* XORI	xor immediate
 * */
extern t_axe_instruction * gen_xori_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);


/* SLTI	Set less than immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_slti_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);
      


/* SLTIU	Set less than unsigned immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_sltiu_instruction(t_program_infos *program
	, int r_dest, int r_source1, int immediate);
      

/////////////////////////////////////////////////
// binary instructions
/////////////////////////////////////////////////


/* ABS	Absolute Value
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_abs_instruction(t_program_infos *program
	, int r_dest, int r_source1);
      

/* CLO	Count leading ones
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_clo_instruction(t_program_infos *program
	, int r_dest, int r_source1);
	
/* CLZ	Count leading zeros
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_clz_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* DV	Divide with overflow (quotient in register lo and the remainder in register hi)
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_dv_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* DVU	Divide without overflow immediate (quotient in register lo and the remainder in register hi)
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_dvu_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* MULT	Signed Multiply (low-order word in lo and high-order word in hi)
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_mult_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* MULTU	Unsigned Multiply (low-order word in lo and high-order word in hi)
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_multu_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* MADD	Multiply add (64 bit result in the concatenated register lo and hi)
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_madd_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* MADDU	Unsigned multiply add (64 bit result in the concatenated register lo and hi)
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_maddu_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* MSUB	Multiply subtract (64 bit result in the concatenated register lo and hi)
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_msub_instruction(t_program_infos *program
	, int r_dest, int r_source1);


/* NEG	Negate value with overflow (pseudoinstruction)
 *. */
extern t_axe_instruction * gen_neg_instruction (t_program_infos *program
      , int r_dest, int r_source1);
		

/* NEGU	Negate value without overflow (pseudoinstruction)
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_negu_instruction(t_program_infos *program
	, int r_dest, int r_source1);


/* NOT	bitwise negation (pseudoinstruction)
 * */
extern t_axe_instruction * gen_not_instruction(t_program_infos *program
	, int r_dest, int r_source1);
      
		

/* JALR	Jump and link register
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_jalr_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* TEQ	Trap if equal
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_teq_instruction(t_program_infos *program
	, int r_dest, int r_source1);

/* TNE	Trap if not equal
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tne_instruction(t_program_infos *program
	, int r_dest, int r_source1);
	

/* TGE	Trap if greater equal
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tge_instruction(t_program_infos *program
	, int r_dest, int r_source1);
	

/* TGEU	Unigned Trap if greater equal
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tgeu_instruction(t_program_infos *program
	, int r_dest, int r_source1);
	

/* TLT	Trap if less than
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tlt_instruction(t_program_infos *program
	, int r_dest, int r_source1);
	

/* TLTU	Unsigned Trap if less than 
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tltu_instruction(t_program_infos *program
	, int r_dest, int r_source1);
	

/* MOVE	Move
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_move_instruction(t_program_infos *program
	, int r_dest, int r_source1);
	
 /////////////////////////////////////////////////
 // unary immediate instructions
 /////////////////////////////////////////////////


/* LUI	Load upper immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_lui_instruction(t_program_infos *program
	, int r_dest, int immediate);	

/* LI	Load immediate (pseudoinstruction)
 * Move the inmediate imm into register rdest
 */
extern t_axe_instruction * gen_li_instruction(t_program_infos *program
	, int r_dest, int immediate);
		

/* TEQI	Trap if equal immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_teqi_instruction(t_program_infos *program
	, int r_dest, int immediate);	

/* TNEI	Trap if not equal immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tnei_instruction(t_program_infos *program
	, int r_dest, int immediate);	

/* TGEI	Trap if greater equal immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tgei_instruction(t_program_infos *program
	, int r_dest, int immediate);	

/* TGEIU	Unsigned trap if greater equal immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tgeiu_instruction(t_program_infos *program
	, int r_dest, int immediate);	

/* TLTI	Trap if less than immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tlti_instruction(t_program_infos *program
	, int r_dest, int immediate);	

/* TLTIU	Unsigned Trap if less than immediate
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_tltiu_instruction(t_program_infos *program
	, int r_dest, int immediate);	

 /////////////////////////////////////////////////
 // Unary instructions
 /////////////////////////////////////////////////


/* JR	Jump register
 * Jump register (jr rs)
 * Unconditionally jump to the instruction whose address is in 
 * register rs*/
 
extern t_axe_instruction * gen_jr_instruction(t_program_infos *program
	, int r_source1);
		

/* MFHI	Move from hi
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_mfhi_instruction(t_program_infos *program
	, int r_dest);	

/* MFLO	Move from lo
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_mflo_instruction(t_program_infos *program
	, int r_dest);	

/* MTHI	Move to hi
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_mthi_instruction(t_program_infos *program
	, int r_source1);	

/* MTLO	Move to lo
 * 
 * 
 * 
 * */
extern t_axe_instruction * gen_mtlo_instruction(t_program_infos *program
	, int r_source1);	


 /////////////////////////////////////////////////
 // load/store instructions
 /////////////////////////////////////////////////

/* A LOAD instruction requires the following parameters:
 * 1.  A destination register (where will be loaded the requested value)
 * 2.  A label information (can be a NULL pointer. If so, the addess
 *     value will be taken into consideration)
 * 3.  A direct address (if label is different from NULL) */

/* LA	Load Address
 * A MOVA instruction copies an address value into a register.
 * An address can be either an instance of `t_axe_label'
 * or a number (numeric address) */
extern t_axe_instruction * gen_la_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LB	Load Byte
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_lb_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LBU	Load unsigned byte
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_lbu_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LH	Load Halfword
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_lh_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LHU	Load unsigned halfword
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_lhu_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LW	Load word
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_lw_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LWC1	Load word coprocessor 1
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_lwc1_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LWL	Load word left
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_lwl_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LWR	Load word right
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_lwr_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* LD	Load doubleword (pseudoinstruction)
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_ld_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* ULH	Unaligned load halfword (pseudoinstruction)
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_ulh_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* ULHU	Unaligned load halfword unsigned (pseudoinstruction)
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_ulhu_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* ULW	Unaligned load word (pseudoinstruction)
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_ulw_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* STORE INSTRUCTIONS */


/* SB	Store Byte
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_sb_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* SH	Store Halfword
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_sh_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* SW	Store word
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_sw_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* SWC1	Store word coprocessor 1
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_swc1_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* SDC1	Store double coprocessor 1
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_sdc1_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* SWL	Store word left
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_swl_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* SWR	Store word right
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_swr_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* SD	Store doubleword (pseudoinstruction)
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_sd_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* USH	Unaligned Store halfword (pseudoinstruction)
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_ush_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

/* USW	Unaligned Store word (pseudoinstruction)
 * 
 * 
 * 
 * */
 extern t_axe_instruction * gen_usw_instruction(t_program_infos *program
	, int r_dest, int r_source1, t_axe_label *label, int immediate, int addressing_mode);

 
 /////////////////////////////////////////////////
 // binary JUMP instructions
 /////////////////////////////////////////////////


/* BEQ	Branch on equal
 *  */
extern t_axe_instruction * gen_beq_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);

/* BNE	Branch on not equal
 * */
extern t_axe_instruction * gen_bne_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);


/* BGE	Branch on greater than equal (pseudoinstruction)
 * */
extern t_axe_instruction * gen_bge_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);
		

/* BGEU	Branch on greater than equal unsigned (pseudoinstruction)
 * 
 * 
 * 
 * */		
extern t_axe_instruction * gen_bgeu_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);
				

/* BGT	Branch on greater than (pseudoinstruction)
 ** */
extern t_axe_instruction * gen_bgt_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);
	

/* BGTU	Branch on greater than unsigned (pseudoinstruction) 
 ** */
extern t_axe_instruction * gen_bgtu_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);

/* BLE	Branch on less than equal (pseudoinstruction)
 ** */
extern t_axe_instruction * gen_ble_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);


/* BLEU	Branch on less than equal unsigned (pseudoinstruction)
 * */
extern t_axe_instruction * gen_bleu_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);


/* BLT	Branch on less than (pseudoinstruction)
 * */
extern t_axe_instruction * gen_blt_instruction(t_program_infos *program
		, int r_source1, int r_source2, t_axe_label *label, int addr);
		


/* BLTU	Branch on less than unsigned (pseudoinstruction)
 * 
 * 
 * 
 * */		
extern t_axe_instruction * gen_bltu_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);

/* BNEZ	Branch on not equal zero (pseudoinstruction)
 * 
 * 
 * 
 * */		
extern t_axe_instruction * gen_bnez_instruction(t_program_infos *program
	, int r_source1, int r_source2, t_axe_label *label, int addr);

 /////////////////////////////////////////////////
 // unary jump instructions
 /////////////////////////////////////////////////

/* BGEZ	Branch on greater than equal zero
 * 
 * 
 * 
 * */		
extern t_axe_instruction * gen_bgez_instruction(t_program_infos *program
	, int r_source1, t_axe_label *label, int addr);

/* BGEZAL	Branch on greater than equal zero and link
 * 
 * 
 * 
 * */		
extern t_axe_instruction * gen_bgezal_instruction(t_program_infos *program
	, int r_source1, t_axe_label *label, int addr);

/* BGTZ	Brach on greater than zero
 * create a "branch on plus (i.e. positive)" instruction. If the bit `N' of the
 * status register is not set, then the branch is taken. */
 
extern t_axe_instruction * gen_bgtz_instruction(t_program_infos *program
	, int r_source1, t_axe_label *label, int addr);

/* BLEZ	Branch on less than equal zero
 * 
 * 
 * 
 * */		
extern t_axe_instruction * gen_blez_instruction(t_program_infos *program
	, int r_source1, t_axe_label *label, int addr);

/* BLTZAL	Branch on less than and link
 * 
 * 
 * 
 * */		
extern t_axe_instruction * gen_bltzal_instruction(t_program_infos *program
	, int r_source1, t_axe_label *label, int addr);

/* BLTZ	Branch on less than zero
 * */
extern t_axe_instruction * gen_bltz_instruction(t_program_infos *program
	, int r_source1, t_axe_label *label, int addr);


/* BEQZ	Branch on equal zero (pseudoinstruction)
 * 
 * 
 * 
 * */		
extern t_axe_instruction * gen_beqz_instruction(t_program_infos *program
	, int r_source1, t_axe_label *label, int addr);

 /////////////////////////////////////////////////
 // unconditionally jump
 /////////////////////////////////////////////////


/* B	Unconditionally Branch
 * */
extern t_axe_instruction * gen_b_instruction(t_program_infos *program
	, t_axe_label *label, int addr);
		
		
/* J	Unconditionally
 * */
extern t_axe_instruction * gen_j_instruction(t_program_infos *program
	,t_axe_label *label, int addr);

/* JAL	Jump and link
 ** */
extern t_axe_instruction * gen_jal_instruction(t_program_infos *program
	,t_axe_label *label, int addr);

 /////////////////////////////////////////////////
 // special instructions
 /////////////////////////////////////////////////

/* NOP
 * */
extern t_axe_instruction * gen_nop_instruction
      (t_program_infos *program);

/* By calling this function, a new HALT instruction will be added
 * */
extern t_axe_instruction * gen_halt_instruction
      (t_program_infos *program);

/* SYSCALL
 * By mean of syscall is posible read and write data in the SPIM
 * console. A syscall doesn't require any parameter but some
 * values must be loaded in the registers $v0 and $ai to setup
 * the call*/
extern t_axe_instruction * gen_syscall_instruction
	(t_program_infos *program);

extern t_axe_instruction * gen_load_store_instruction (t_program_infos *program
        , int opcode, int r_dest, int r_source1, t_axe_label *label
	, int immediate, int addressing_mode);
	
#endif
